/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.graphics;

import com.ibm.hwmca.fw.servlet.graphics.GraphicsHelper;
import com.ibm.hwmca.fw.servlet.graphics.ImageUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PieChart
implements GraphicsHelper {
    public static final String TRACE_MASKT = "XGFXPIET";
    public static final String TRACE_MASKF = "XGFXPIEF";
    public static final String TRACE_MASKD = "XGFXPIED";
    public static final String PARAM_COLORS = "colors";
    public static final String PARAM_PERCENTAGES = "percentages";
    public static final String PARAM_SIZE = "size";

    public static void drawChartAsApp(int[] colors, double[] percentages, int circleSize) {
        if (colors == null || percentages == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        if (colors.length - 1 != percentages.length) {
            throw new IllegalArgumentException("Colors array must be one larger than the percentages array");
        }
        JFrame jf = new JFrame();
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        jf.setSize(circleSize * 2, circleSize * 2);
        JPanel jp = new JPanel();
        jf.getContentPane().add(jp);
        jf.show();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        Graphics g = jp.getGraphics();
        g.setColor(new Color(colors[colors.length - 1]));
        g.fillOval(circleSize / 2, circleSize / 2, circleSize, circleSize);
        int runningArcLocation = 0;
        int percentageIdx = 0;
        while (percentageIdx < percentages.length) {
            g.setColor(new Color(colors[percentageIdx]));
            int arcAngle = PieChart.calculateArc(percentages[percentageIdx]);
            g.fillArc(circleSize / 2, circleSize / 2, circleSize, circleSize, runningArcLocation, arcAngle);
            runningArcLocation += arcAngle;
            ++percentageIdx;
        }
    }

    private static int calculateArc(double percentage) {
        return (int)(percentage / 100.0 * 360.0);
    }

    public static Image drawChart(int[] colors, double[] percentages, int circleSize) {
        int y;
        int x;
        if (colors == null || percentages == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        if (colors.length - 1 != percentages.length) {
            throw new IllegalArgumentException("Colors array must be one larger than the percentages array");
        }
        BufferedImage image = new BufferedImage(circleSize + 2, circleSize + 2, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(colors[colors.length - 1]));
        g.fillOval(0, 0, circleSize, circleSize);
        int runningArcLocation = 0;
        int percentageIdx = 0;
        while (percentageIdx < percentages.length) {
            g.setColor(new Color(colors[percentageIdx]));
            int arcAngle = PieChart.calculateArc(percentages[percentageIdx]);
            g.fillArc(0, 0, circleSize, circleSize, runningArcLocation, arcAngle);
            runningArcLocation += arcAngle;
            ++percentageIdx;
        }
        g.setColor(Color.black);
        g.drawOval(0, 0, circleSize, circleSize);
        int angle = 0;
        int center = Math.round(circleSize / 2);
        int i = 0;
        while (i < percentages.length) {
            x = Math.round((float)((double)center * Math.cos(Math.toRadians(angle))));
            y = Math.round((float)((double)center * Math.sin(Math.toRadians(angle))));
            g.drawLine(center, center, center + x, center - y);
            angle += PieChart.calculateArc(percentages[i]);
            ++i;
        }
        x = Math.round((float)((double)center * Math.cos(Math.toRadians(angle))));
        y = Math.round((float)((double)center * Math.sin(Math.toRadians(angle))));
        g.drawLine(center, center, center + x, center - y);
        return image;
    }

    public static String buildURI(int[] colors, double[] percentages, int circleSize) {
        if (colors == null || percentages == null) {
            throw new IllegalArgumentException("Parameters to buildURL may not be null!");
        }
        String colorsString = "";
        int i = 0;
        while (i < colors.length) {
            colorsString = i > 0 ? colorsString + "," + colors[i] : colorsString + colors[i];
            ++i;
        }
        String percentagesString = "";
        int i2 = 0;
        while (i2 < percentages.length) {
            percentagesString = i2 > 0 ? percentagesString + "," + percentages[i2] : percentagesString + percentages[i2];
            ++i2;
        }
        return "/hmc/graphics?chartType=typePie&colors=" + colorsString + "&" + PARAM_PERCENTAGES + "=" + percentagesString + "&" + PARAM_SIZE + "=" + circleSize;
    }

    public static void main(String[] args) {
        System.out.println(PieChart.buildURI(new int[]{0xFF0000, 65280, 255}, new double[]{25.0, 50.0}, 100));
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        Trace.trace(TRACE_MASKT, "handleRequest()");
        try {
            String colorsString = request.getParameter(PARAM_COLORS);
            String percentagesString = request.getParameter(PARAM_PERCENTAGES);
            String sizeString = request.getParameter(PARAM_SIZE);
            int size = Integer.parseInt(sizeString);
            Trace.trace(TRACE_MASKF, "parsed size parameter");
            StringTokenizer st = new StringTokenizer(percentagesString, ",");
            Trace.trace(TRACE_MASKF, "percentages parameter (" + percentagesString + ") - token count: " + st.countTokens());
            double[] percentages = new double[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                percentages[i++] = Double.parseDouble(st.nextToken().trim());
            }
            Trace.trace(TRACE_MASKD, "parsed percentages parameter");
            st = new StringTokenizer(colorsString, ",");
            Trace.trace(TRACE_MASKF, "colors parameter (" + colorsString + ") - token count: " + st.countTokens());
            int[] colors = new int[st.countTokens()];
            i = 0;
            while (st.hasMoreTokens()) {
                colors[i++] = Integer.parseInt(st.nextToken().trim());
            }
            Trace.trace(TRACE_MASKD, "parsed colors parameter");
            response.setContentType("image/png");
            Image chart = PieChart.drawChart(colors, percentages, size);
            ImageUtil.writeImage(chart, "image/png", response.getOutputStream());
            Trace.trace(TRACE_MASKF, "wrote stream");
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                response.getOutputStream().close();
            }
            catch (Exception e2) {}
        }
    }
}

